﻿<?php
	include_once('header.php');
	$leaderboardsList = [];
	$achievementsList = [];

	if ($stmt = $user_home->runQuery("SELECT * FROM leaderboards")) {
		while ($row = $stmt->fetch_array(MYSQLI_ASSOC)) {
			$leaderboardsList[] = $row;
		}
	}

	if ($stmt = $user_home->runQuery("SELECT * FROM achievements")) {
		while ($rowsa = $stmt->fetch_array(MYSQLI_ASSOC)) {
			$achievementsList[] = $rowsa;
		}
	}
?>
    <div id="message" style="display:none;">
        <div class="" id="alert">

        </div>
    </div>
    <div class="row">
        <div class="col">
            <div class="widget widget-table">
                <div class="widget-header"> <i class="icon-list-ol"></i>
                    <h3> <?= $lang['leaderboards']; ?></h3>
                </div>
                <div class="widget-content">
                    <table class="table table-bordered table-striped table-hover" id="paginated">
                        <thead class="thead-inverse">
                            <tr>
                                <th>
                                    <?= $lang['leaderboard_name']; ?>
                                </th>
                                <th>
                                    <?= $lang['scores_count']; ?>
                                </th>
								<th></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if(count($leaderboardsList)==0) {
								echo '<tr><td colspan="3"><div class="alert alert-danger">'.$lang["no_leaderboard"].'</div></td></tr>';
							} ?>
                                <?php foreach ($leaderboardsList as $leaderboard) : ?>
                                    <tr>
                                        <td style="font-size: 15px;">
                                            <?= $leaderboard['name']; ?>
                                        </td>
                                        <td style="font-size: 15px;">
<?php
	$leaderboardScores = [];
	$table = $leaderboard['token'].'_scores';
	if ($stmt = $user_home->runQuery("SELECT * FROM $table")) {
		while ($rows = $stmt->fetch_array(MYSQLI_ASSOC)) {
			$leaderboardScores[] = $rows;
		}
	}
	echo count($leaderboardScores);
?>
                                        </td>
										<td>
											<a href="scores.php?id=<?= $leaderboard['id']; ?>" class="btn btn-primary btn-sm" title=""><i class="icon-bar-chart"></i>&nbsp;&nbsp;<?= $lang['scores']; ?></i></a>
											<a href="embed.php?type=leaderboard&id=<?= $leaderboard['id']; ?>" class="btn btn-primary btn-sm" title=""><i class="icon-qrcode"></i>&nbsp;&nbsp;<?= $lang['embed_code']; ?></i></a>
										</td>
                                    </tr>
                                    <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
	<div class="col">
            <div class="widget widget-table">
                <div class="widget-header"> <i class="icon-trophy"></i>
                    <h3> <?= $lang['achievements']; ?></h3>
                </div>
                <div class="widget-content">
                    <table class="table table-bordered table-striped table-hover" id="paginated2">
                        <thead class="thead-inverse">
                            <tr>
                                <th>
                                    <?= $lang['achievement_name']; ?>
                                </th>
                                <th>
                                    <?= $lang['hits_count']; ?>
                                </th>
								<th></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if(count($achievementsList)==0) {
								echo '<tr><td colspan="3"><div class="alert alert-danger">'.$lang["no_achievement"].'</div></td></tr>';
							} ?>
                                <?php foreach ($achievementsList as $achievement) : ?>
                                    <tr>
                                        <td style="font-size: 15px;">
                                            <?= $achievement['name']; ?>
                                        </td>
                                        <td style="font-size: 15px;">
<?php
	$achievementHits = [];
	$table = $achievement['token'].'_hits';
	if ($stmt = $user_home->runQuery("SELECT * FROM $table")) {
		while ($rows = $stmt->fetch_array(MYSQLI_ASSOC)) {
			$achievementHits[] = $rows;
		}
	}
	echo count($achievementHits);
?>
                                        </td>
										<td>
											<a href="hits.php?id=<?= $achievement['id']; ?>" class="btn btn-primary btn-sm" title=""><i class="icon-bar-chart"></i>&nbsp;&nbsp;<?= $lang['hits']; ?></i></a>
											<a href="embed.php?type=achievement&id=<?= $leaderboard['id']; ?>" class="btn btn-primary btn-sm" title=""><i class="icon-qrcode"></i>&nbsp;&nbsp;<?= $lang['embed_code']; ?></i></a>
										</td>
                                    </tr>
                                    <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
<?php include_once('footer.php'); ?>